function [Dis] = MeEquiMatch(q, Nf, Psim, Psif, e, wS_m, wS_f, wU_m, wU_f, mu)
%EquiMatch is the equilibrium conditions used to solve model


qSS_m=q(1); %tells there are 8 q, q as independent var, label var var(i)
qSS_f=q(2);
qUS_m=q(3);
qUS_f=q(4);
qSU_m=q(5);
qSU_f=q(6);
qUU_m=q(7);
qUU_f=q(8); 


thetaSm=(1-Nf)*Psim+Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*Psim*(1-Psif)*max(qSU_m,qSU_f);
thetaUm=(1-Nf)*(1-Psim)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);
thetaSf=Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f);
thetaUf=Nf*Psim*(1-Psif)*max(qSU_m,qSU_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);


Dis(1)=min((thetaSf/thetaSm),1)*(log(e*(wS_m+wS_f))+mu)+(1-min((thetaSf/thetaSm),1))*log(wS_m)-(log(e*(wS_m+wS_f))+qSS_m);
Dis(2)=min((thetaSm/thetaSf),1)*(log(e*(wS_m+wS_f))+mu)+(1-min((thetaSm/thetaSf),1))*log(wS_f)-(log(e*(wS_m+wS_f))+qSS_f);
Dis(3)=min((thetaUf/thetaUm),1)*(log(e*(wU_m+wU_f))+mu)+(1-min((thetaUf/thetaUm),1))*log(wU_m)-(log(e*(wU_m+wS_f))+qUS_m);
Dis(4)=min((thetaSm/thetaSf),1)*(log(e*(wS_m+wS_f))+mu)+(1-min((thetaSm/thetaSf),1))*log(wS_f)-(log(e*(wU_m+wS_f))+qUS_f);
Dis(5)=min((thetaSf/thetaSm),1)*(log(e*(wS_m+wS_f))+mu)+(1-min((thetaSf/thetaSm),1))*log(wS_m)-(log(e*(wS_m+wU_f))+qSU_m);
Dis(6)=min((thetaUm/thetaUf),1)*(log(e*(wU_m+wU_f))+mu)+(1-min((thetaUm/thetaUf),1))*log(wU_f)-(log(e*(wS_m+wU_f))+qSU_f);
Dis(7)=min((thetaUf/thetaUm),1)*(log(e*(wU_m+wU_f))+mu)+(1-min((thetaUf/thetaUm),1))*log(wU_m)-(log(e*(wU_m+wU_f))+qUU_m);
Dis(8)=min((thetaUm/thetaUf),1)*(log(e*(wU_m+wU_f))+mu)+(1-min((thetaUm/thetaUf),1))*log(wU_f)-(log(e*(wU_m+wU_f))+qUU_f);


end

